<?php
require_once 'config.php';
require_once 'CycleAPI.php';

if (!isset($_POST['agent_id'], $_POST['date'])) {
    die("Missing agent_id or date");
}

$agentId = intval($_POST['agent_id']);
$date = $_POST['date']; // Format: Y-m-d

$from = $date . "T00:00:00";
$to = date("Y-m-d", strtotime("$date +1 day")) . "T00:00:00";

$api = new CycleAPI();
$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
if ($conn->connect_error) {
    die("DB connection failed");
}

$res = $conn->query("SELECT * FROM submerchants WHERE cycle_agent_id = $agentId");
if (!$res || $res->num_rows === 0) {
    die("Agent not found");
}

$agent = $res->fetch_assoc();
$txs = $api->getAgentTransactionsByHistoryEx($agentId, $from, $to);

$total = $fee = $net = 0;
$tx_ids = [];
foreach ($txs as $tx) {
    if (($tx['Substate'] ?? null) == 411) {
        $amt = $tx['Amount'];
        $f = $amt * ($agent['fee_percent'] / 100);
        $total += $amt;
        $fee += $f;
        $net += ($amt - $f);
        $tx_ids[] = $tx['ID'];
    }
}

if (empty($tx_ids)) {
    die("No transactions found for this agent on this date");
}

$period_start = $date . " 00:00:00";
$period_end = $date . " 23:59:59";
$status = "Paid";
$jsonTx = json_encode($tx_ids);

$stmt = $conn->prepare("INSERT INTO settlements (submerchant_id, period_start, period_end, total_amount, total_fees, net_payout, payout_status, payout_date, linked_transactions) VALUES (?, ?, ?, ?, ?, ?, ?, NOW(), ?)");
$stmt->bind_param("issddsss", $agent['id'], $period_start, $period_end, $total, $fee, $net, $status, $jsonTx);
$stmt->execute();

if ($stmt->affected_rows > 0) {
    header("Location: settlements.php?from=$date&to=$date");
    exit;
} else {
    die("❌ Failed to insert settlement.");
}
