<?php
session_start();

// Show errors for debugging (disable in production)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Redirect if already logged in
if (isset($_SESSION['user_id'])) {
    header("Location: admin.php");
    exit;
}

require_once 'config.php';

// DB connection
$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
if ($conn->connect_error) {
    die("❌ Database connection failed: " . $conn->connect_error);
}

$error = null;

// Handle login
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email'] ?? '');
    $password = trim($_POST['password'] ?? '');

    if ($email && $password) {
        $hash = hash('sha256', $password);

        $stmt = $conn->prepare("SELECT * FROM users WHERE email = ? AND password = ?");
        $stmt->bind_param("ss", $email, $hash);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($user = $result->fetch_assoc()) {
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['email'] = $user['email'];
            $_SESSION['name'] = $user['name'] ?? '';
            $_SESSION['role'] = $user['role'] ?? 'admin';
            $_SESSION['cycle_user_id'] = $user['cycle_user_id'] ?? null;

            // Optional: record last login
            $conn->query("UPDATE users SET last_login = NOW() WHERE id = " . intval($user['id']));

            header("Location: admin.php");
            exit;
        } else {
            $error = "❌ Invalid email or password.";
        }
    } else {
        $error = "❗ Please enter both email and password.";
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Swirl Admin Login</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 flex items-center justify-center min-h-screen">
    <div class="bg-white p-8 rounded shadow-md max-w-sm w-full">
        <h2 class="text-2xl font-bold text-purple-700 mb-6 text-center">🔐 Swirl Admin Login</h2>

        <?php if ($error): ?>
            <div class="text-red-600 text-sm mb-4 text-center"><?= htmlspecialchars($error) ?></div>
        <?php endif; ?>

        <form method="POST" class="space-y-4">
            <input type="email" name="email" placeholder="Email" required class="w-full p-2 border border-gray-300 rounded">
            <input type="password" name="password" placeholder="Password" required class="w-full p-2 border border-gray-300 rounded">
            <button type="submit" class="w-full bg-purple-600 hover:bg-purple-700 text-white py-2 rounded">Login</button>
        </form>
    </div>
</body>
</html>
