<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();
$_SESSION['user_id'] = 1;
$_SESSION['email'] = 'admin@swirl.io';
$_SESSION['name'] = 'Swirl Admin';
$_SESSION['role'] = 'admin';

require_once 'config.php';
require_once 'CycleAPI.php';

$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
if ($conn->connect_error) {
    die("DB Connection Failed: " . $conn->connect_error);
}

$cycle = new CycleAPI();
$merchantId = 115392;

// === Create Submerchant (Branch), Terminal, and Agent ===
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['create_agent'])) {
    $branchId = $_POST['branch_id'];
    $name = $_POST['name'];
    $email = $_POST['email'];
    $fee = $_POST['fee_percent'];
    $bank = $_POST['bank_name'];
    $account = $_POST['account_number'];
    $holder = $_POST['account_holder'];
    $mcc = $_POST['mcc_code'];
    $alias = $_POST['terminal_alias'];
    $city = $_POST['city'];
    $region = $_POST['region_code'];
    $location = $_POST['location'];

    $deviceId = uniqid("swirl_");

    // === Terminal Creation Payload ===
    $terminalName = 'TID_' . uniqid();
    $terminalPayload = [
        "ClientID" => $merchantId, // ✅ Required field added
        "BranchID" => intval($branchId),
        "Name" => $terminalName,
        "Title" => $terminalName,
        "Alias" => $alias,
        "SIC" => $mcc,
        "Currency" => "710",
        "Country" => "710",
        "City" => $city,
        "Location" => $location,
        "TerminalGroupCode" => "DEFAULT",
        "EntryCaps" => "5",
        "RegionCode" => $region,
        "CountryCode" => "ZA",
        "DeviceInfo" => [
            "PhoneManufacturer" => "Cycle",
            "PhoneModel" => "AgentTerminal",
            "DeviceID" => $deviceId,
            "DeviceType" => "1",
            "AppFramework" => "java",
            "YOU" => "Linux",
            "OSVersion" => "1.0",
            "AppID" => "SwirlTerminal",
            "BuildNumber" => "1.0"
        ],
        "GMT" => 2,
        "AppFramework" => "java",
        "IP" => $_SERVER['REMOTE_ADDR'] ?? "105.186.112.50",
        "Just" => "EN"
    ];

    $terminalRes = $cycle->createTerminal($terminalPayload);
    $terminalId = $terminalRes['Terminal']['ID'] ?? null;

    if ($terminalId) {
        // === Agent Creation Payload ===
        $agentPayload = [
            "Name" => $name,
            "Email" => $email,
            "Phone" => "+27111222333",
            "ClientID" => $merchantId,
            "BranchID" => intval($branchId),
            "State" => 1,
            "Password" => "123123123",
            "SecretKey" => "123123123",
            "SendWelcomeEmail" => false,
            "AccountType" => 20,
            "Location" => ["Latitude" => -33.918861, "Longitude" => 18.423300],
            "Country" => "South Africa",
            "CountryCode" => "ZA",
            "DeviceInfo" => [
                "PhoneManufacturer" => "Cycle",
                "PhoneModel" => "AgentAdd",
                "DeviceID" => $deviceId,
                "DeviceType" => "1",
                "AppFramework" => "java",
                "YOU" => "Linux",
                "OSVersion" => "1.0",
                "AppID" => "SwirlAdmin",
                "BuildNumber" => "1.0"
            ],
            "GMT" => 2,
            "AppFramework" => "java",
            "IP" => $_SERVER['REMOTE_ADDR'] ?? "105.186.112.50",
            "Just" => "EN",
            "MobileSettings" => [
                "Features" => [
                    "AcceptCards" => true,
                    "AcceptCash" => true,
                    "AcceptPrepaid" => true,
                    "AcceptCredit" => true,
                    "AcceptOuterCard" => true
                ]
            ]
        ];

        $agentRes = $cycle->createAgent($merchantId, $agentPayload);
        $agentId = $agentRes['Pos']['ID'] ?? null;

        if ($agentId) {
            $stmt = $conn->prepare("INSERT INTO submerchants (user_id, cycle_agent_id, name, fee_percent, bank_name, account_number, account_holder, mcc_code, terminal_ids, cycle_branch_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            $terminalJson = json_encode([$terminalId]);
            $stmt->bind_param("iisdsssssi", $_SESSION['user_id'], $agentId, $name, $fee, $bank, $account, $holder, $mcc, $terminalJson, $branchId);
            $stmt->execute();

            $agents = file_exists("agents.json") ? json_decode(file_get_contents("agents.json"), true) : [];
            $agents[] = ["AgentID" => $agentId, "Name" => $name];
            file_put_contents("agents.json", json_encode($agents, JSON_PRETTY_PRINT));

            $success = "✅ Submerchant created: Agent ID $agentId and Terminal ID $terminalId (Branch $branchId)";
        } else {
            $error = "✅ Terminal created (ID: $terminalId), but agent creation failed:<br><pre>" . json_encode($agentRes, JSON_PRETTY_PRINT) . "</pre>";
        }
    } else {
        $error = "❌ Terminal creation failed:<br><pre>" . json_encode($terminalRes, JSON_PRETTY_PRINT) . "</pre>";
    }
}





// === Filter & Transaction Calculation ===
$filter = $_GET['filter'] ?? 'month';
switch ($filter) {
    case 'day': $from = $to = date('Y-m-d'); break;
    case 'week': $from = date('Y-m-d', strtotime('monday this week')); $to = date('Y-m-d'); break;
    case 'year': $from = date('Y-01-01'); $to = date('Y-m-d'); break;
    case 'custom': $from = $_GET['from'] ?? date('Y-m-01'); $to = $_GET['to'] ?? date('Y-m-d'); break;
    default: $from = date('Y-m-01'); $to = date('Y-m-d');
}

$transactions = $cycle->getClientTransactions($from, $to);
$totalVolume = 0;
$totalTx = count($transactions);
foreach ($transactions as $tx) {
    if (($tx['Substate'] ?? null) == 411) $totalVolume += $tx['Amount'];
}

$agentCount = $conn->query("SELECT COUNT(*) as cnt FROM submerchants")->fetch_assoc()['cnt'];
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Swirl Super Admin Dashboard</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 text-gray-800">
  <div class="flex min-h-screen">
    <!-- Sidebar -->
    <aside class="w-64 bg-white border-r p-6 space-y-6">
      <div class="flex items-center gap-3">
        <div class="w-10 h-10 bg-purple-600 rounded-full flex items-center justify-center text-white font-bold">S</div>
        <div>
          <h1 class="font-bold text-lg">Swirl</h1>
          <p class="text-xs text-gray-400">Payfac Admin</p>
        </div>
      </div>
      <nav class="space-y-3 text-sm">
        <a href="admin.php" class="block text-purple-700 font-semibold">Summary</a>
        <a href="history.php" class="block text-gray-600 hover:text-purple-600">Transactions</a>
        <a href="settlements.php" class="block text-gray-600 hover:text-purple-600">Settlements</a>
        <a href="#add-agent" class="block text-gray-600 hover:text-purple-600">Add Merchant</a>
        <a href="logout.php" class="block text-red-500">Logout</a>
      </nav>
    </aside>

    <!-- Main -->
    <main class="flex-1 p-8 space-y-10">
      <div class="flex justify-between items-center">
        <div>
          <h2 class="text-2xl font-bold">Dashboard</h2>
          <p class="text-sm text-gray-500">Logged in as <?= $_SESSION['name'] ?></p>
        </div>
<form method="GET" class="flex flex-wrap gap-2 items-center mb-4">
  <?php
    $options = [
        'day' => 'Today',
        'week' => 'This Week',
        'month' => 'This Month',
        'year' => 'This Year',
        'custom' => 'Custom'
    ];
    foreach ($options as $key => $label):
      $isActive = ($filter === $key);
  ?>
    <button 
      type="submit" 
      name="filter" 
      value="<?= $key ?>" 
      class="px-4 py-2 text-sm font-medium rounded-full border transition-all <?= $isActive ? 'bg-purple-600 text-white border-purple-600' : 'bg-white text-gray-600 hover:bg-purple-100 border-gray-300' ?>"
    >
      <?= $label ?>
    </button>
  <?php endforeach; ?>
</form>

<!-- ✅ CUSTOM DATE RANGE (only when 'custom' selected) -->
<?php if ($filter === 'custom'): ?>
  <form method="GET" class="flex flex-wrap gap-2 items-center mb-6">
    <input type="hidden" name="filter" value="custom">
    <input type="date" name="from" value="<?= htmlspecialchars($from) ?>" required class="rounded-full border border-gray-300 px-4 py-2 text-sm">
    <span class="text-gray-500">→</span>
    <input type="date" name="to" value="<?= htmlspecialchars($to) ?>" required class="rounded-full border border-gray-300 px-4 py-2 text-sm">
    <button type="submit" class="bg-purple-600 text-white px-4 py-2 text-sm rounded-full hover:bg-purple-700">Apply</button>
  </form>
<?php endif; ?>

      </div>

      <?php if (isset($success)): ?>
        <div class="bg-green-100 text-green-700 p-4 rounded shadow"><?= $success ?></div>
      <?php elseif (isset($error)): ?>
        <div class="bg-red-100 text-red-700 p-4 rounded shadow"><?= $error ?></div>
      <?php endif; ?>

      <!-- Metrics Cards -->
<div class="grid grid-cols-1 md:grid-cols-4 gap-6">
  <div class="bg-white p-6 rounded-2xl shadow">
    <p class="text-sm text-gray-400">Total Volume</p>
    <p class="text-3xl font-bold text-black-00">R<?= number_format($totalVolume, 2) ?></p>
  </div>
  <div class="bg-white p-6 rounded-2xl shadow">
    <p class="text-sm text-gray-400">Transactions</p>
    <p class="text-3xl font-bold text-black-700"><?= $totalTx ?></p>
  </div>
  <div class="bg-white p-6 rounded-2xl shadow">
    <p class="text-sm text-gray-400">Payable Amount</p>
    <p class="text-3xl font-bold text-black-700">Coming Soon</p>
  </div>
  <div class="bg-white p-6 rounded-2xl shadow">
    <p class="text-sm text-gray-400">Total Agents</p>
    <p class="text-3xl font-bold text-black-700"><?= $agentCount ?></p>
  </div>
</div>

<!-- Expanded Dashboard Features -->
<div class="grid grid-cols-1 md:grid-cols-2 xl:grid-cols-3 gap-6">
  <div class="bg-white p-6 rounded-2xl shadow">
    <h3 class="text-md font-semibold text-gray-600 mb-2">Payment Method Breakdown</h3>
    <p class="text-sm text-gray-400">Coming Soon (Bar Chart)</p>
  </div>
  <div class="bg-white p-6 rounded-2xl shadow">
    <h3 class="text-md font-semibold text-gray-600 mb-2">Top Performing Agents</h3>
    <p class="text-sm text-gray-400">Coming Soon (Leaderboard)</p>
  </div>
  <div class="bg-white p-6 rounded-2xl shadow">
    <h3 class="text-md font-semibold text-gray-600 mb-2">Agent Geolocation</h3>
    <p class="text-sm text-gray-400">Map view coming soon</p>
  </div>
  <div class="bg-white p-6 rounded-2xl shadow">
    <h3 class="text-md font-semibold text-gray-600 mb-2">Pending Settlements</h3>
    <p class="text-sm text-gray-400">Coming Soon</p>
  </div>
  <div class="bg-white p-6 rounded-2xl shadow">
    <h3 class="text-md font-semibold text-gray-600 mb-2">Average Txn Time</h3>
    <p class="text-sm text-gray-400">Data loading</p>
  </div>
  <div class="bg-white p-6 rounded-2xl shadow">
    <h3 class="text-md font-semibold text-gray-600 mb-2">Alerts & Exceptions</h3>
    <p class="text-sm text-gray-400">Failed txns, spikes (placeholder)</p>
  </div>
</div>


<!-- Agent Form -->
<div class="bg-white p-6 rounded-2xl shadow max-w-4xl" id="add-agent">
  <h2 class="text-xl font-semibold text-purple-600 mb-4">➕ Create New Submerchant</h2>
  <form method="POST" class="grid grid-cols-2 md:grid-cols-3 gap-4">
    <input type="hidden" name="create_agent" value="1">

    <!-- Branch (Submerchant) Info -->
    <input type="text" name="branch_id" placeholder="Branch ID (from Cycle Dashboard)" required class="p-3 border rounded-full text-sm">
    
    <!-- Merchant Info -->
    <input type="text" name="name" placeholder="Merchant Full Name" required class="p-3 border rounded-full text-sm">
    <input type="email" name="email" placeholder="Email" required class="p-3 border rounded-full text-sm">
    <input type="number" step="0.01" name="fee_percent" placeholder="Fee % (e.g. 2.5)" required class="p-3 border rounded-full text-sm">
    <input type="text" name="bank_name" placeholder="Bank Name" required class="p-3 border rounded-full text-sm">
    <input type="text" name="account_number" placeholder="Account Number" required class="p-3 border rounded-full text-sm">
    <input type="text" name="account_holder" placeholder="Account Holder" required class="p-3 border rounded-full text-sm">

    <!-- Terminal Info -->
    <input type="text" name="mcc_code" placeholder="MCC Code (e.g. 5411)" required class="p-3 border rounded-full text-sm">
    <input type="text" name="terminal_alias" placeholder="Terminal Alias" required class="p-3 border rounded-full text-sm">
    <input type="text" name="city" placeholder="City" required class="p-3 border rounded-full text-sm">
    <input type="text" name="region_code" placeholder="Region Code (e.g. 77)" required class="p-3 border rounded-full text-sm">
    <input type="text" name="location" placeholder="Location (e.g. Johannesburg)" required class="p-3 border rounded-full text-sm">

    <div class="col-span-2 md:col-span-3 mt-2">
      <button type="submit" class="bg-purple-600 hover:bg-purple-700 text-white px-6 py-2 rounded-full text-sm shadow transition-all w-full">
        🚀 Create Submerchant (Branch) & Terminal
      </button>
    </div>
  </form>
</div>
    </main>
  </div>
</body>
</html>
