<?php
require_once '../../core/init.php';
require_once 'sidebar.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header("Location: ../../auth/admin/login.php");
    exit;
}

// Fetch unique batch payout references
$batches = $conn->query("SELECT DISTINCT payout_reference FROM settlements WHERE payout_status = 'Batch Created' ORDER BY payout_reference ASC")->fetch_all(MYSQLI_ASSOC);

// Handle batch mark as paid
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['selected_batches'])) {
    $selected = $_POST['selected_batches'];

    foreach ($selected as $batchReference) {
        $stmt = $conn->prepare("UPDATE settlements SET payout_status = 'Paid', payout_date = NOW() WHERE payout_reference = ?");
        $stmt->bind_param("s", $batchReference);
        $stmt->execute();
    }

    header("Location: batch_mark_paid.php?success=1");
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Mark Batches Paid | Swirl</title>
  <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-50 text-gray-800">
<div class="flex min-h-screen">

  <!-- Sidebar -->
  <?php require_once 'sidebar.php'; ?>

  <main class="ml-64 flex-1 p-8">
    <div class="flex justify-between items-center mb-6">
      <div>
        <h1 class="text-2xl font-bold text-purple-700">🏦 Mark Batch as Paid</h1>
        <p class="text-gray-500 text-sm">Select completed payout batches and mark them as paid.</p>
      </div>
    </div>

    <?php if (isset($_GET['success'])): ?>
      <div class="bg-green-100 text-green-700 p-4 rounded mb-6">
        ✅ Selected batches successfully marked as Paid!
      </div>
    <?php endif; ?>

    <form method="POST">
      <div class="bg-white rounded shadow-md overflow-auto mb-6">
        <table class="min-w-full text-sm">
          <thead class="bg-gray-100 text-gray-600 uppercase text-xs">
            <tr>
              <th class="px-4 py-3"><input type="checkbox" onclick="toggleSelectAll(this)" /></th>
              <th class="px-4 py-3 text-left">Payout Batch Reference</th>
            </tr>
          </thead>
          <tbody class="divide-y divide-gray-200">
            <?php if (empty($batches)): ?>
              <tr><td colspan="2" class="text-center p-6 text-gray-400 italic">No payout batches found needing payment.</td></tr>
            <?php else: ?>
              <?php foreach ($batches as $batch): ?>
                <tr class="hover:bg-gray-50">
                  <td class="px-4 py-2">
                    <input type="checkbox" name="selected_batches[]" value="<?= htmlspecialchars($batch['payout_reference']) ?>">
                  </td>
                  <td class="px-4 py-2"><?= htmlspecialchars($batch['payout_reference']) ?></td>
                </tr>
              <?php endforeach; ?>
            <?php endif; ?>
          </tbody>
        </table>
      </div>

      <?php if (!empty($batches)): ?>
      <div class="text-right">
        <button type="submit" class="bg-green-600 hover:bg-green-700 text-white px-6 py-3 rounded-md text-sm shadow">✅ Mark Selected as Paid</button>
      </div>
      <?php endif; ?>
    </form>

  </main>

</div>

<script>
function toggleSelectAll(source) {
  checkboxes = document.getElementsByName('selected_batches[]');
  for(var i=0, n=checkboxes.length;i<n;i++) {
    checkboxes[i].checked = source.checked;
  }
}
</script>
</body>
</html>
