<?php
require_once '../../core/init.php';

$cycle = new CycleAPI();

// Default to settling yesterday's transactions
$date = date('Y-m-d', strtotime('-1 day'));
$from = $date . "T00:00:00";
$to = date("Y-m-d", strtotime($date . " +1 day")) . "T00:00:00";

// Load all agents
$agents = $conn->query("SELECT * FROM submerchants");

while ($agent = $agents->fetch_assoc()) {
    $agentId = $agent['cycle_agent_id'];

    $txs = $cycle->getAgentTransactionsByHistoryEx($agentId, $from, $to);

    $total = $fee = $net = 0;
    $tx_ids = [];

    foreach ($txs as $tx) {
        if (($tx['Substate'] ?? null) == 411) {
            $amt = $tx['Amount'];
            $f = $amt * ($agent['fee_percent'] / 100);
            $total += $amt;
            $fee += $f;
            $net += ($amt - $f);
            $tx_ids[] = $tx['ID'];
        }
    }

    if ($total > 0) {
        $period_start = $date . " 00:00:00";
        $period_end = $date . " 23:59:59";
        $status = "Pending"; // not Paid yet, ready to process

        $stmt = $conn->prepare("INSERT INTO settlements (submerchant_id, period_start, period_end, total_amount, total_fees, net_payout, payout_status, payout_date, linked_transactions) VALUES (?, ?, ?, ?, ?, ?, ?, NOW(), ?)");
        $jsonTx = json_encode($tx_ids);
        $stmt->bind_param("issddsss", $agent['id'], $period_start, $period_end, $total, $fee, $net, $status, $jsonTx);
        $stmt->execute();

        $logStmt = $conn->prepare("INSERT INTO settlement_logs (submerchant_id, period_start, period_end, total_amount, total_fees, net_payout, payout_status, payout_date, created_by, method) VALUES (?, ?, ?, ?, ?, ?, ?, NOW(), 'System', 'Automatic')");
        $logStmt->bind_param("issddsss", $agent['id'], $period_start, $period_end, $total, $fee, $net, $status);
        $logStmt->execute();
    }
}

echo "✅ Automatic settlement run completed.";
?>
