<?php
require_once '../../core/init.php'; // Correct path for new structure

// Fetch agents
$agents = [];
$result = $conn->query("SELECT cycle_agent_id, name FROM submerchants");
while ($row = $result->fetch_assoc()) {
    $agents[] = [
        "AgentID" => $row['cycle_agent_id'],
        "Name" => $row['name']
    ];
}

// Save agents to /storage/agents.json
file_put_contents('../../storage/agents.json', json_encode($agents, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES));

echo "✅ agents.json created successfully with " . count($agents) . " agents.";
?>
